#
# TABLE STRUCTURE FOR: tb_aplikasi
#

DROP TABLE IF EXISTS `tb_aplikasi`;

CREATE TABLE `tb_aplikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `logo` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_aplikasi` (`id`, `nama`, `telp`, `email`, `alamat`, `logo`) VALUES (1, 'Bimbel Easy App', '081234567890', 'easyapp@gmail.com', 'Jombang, Jawa Timur', 'Logo-1768105230.png');


#
# TABLE STRUCTURE FOR: tb_backupdb
#

DROP TABLE IF EXISTS `tb_backupdb`;

CREATE TABLE `tb_backupdb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `database` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_kelas
#

DROP TABLE IF EXISTS `tb_kelas`;

CREATE TABLE `tb_kelas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kelas` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=120 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (115, 'AHE', '2026-01-16 13:47:08');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (116, 'ASE', '2026-01-16 13:47:16');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (117, 'AGA', '2026-01-16 13:47:25');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (118, 'PRACALIS', '2026-01-16 13:47:34');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (119, 'LET\"S GO', '2026-01-16 13:48:04');


#
# TABLE STRUCTURE FOR: tb_kelas_peserta
#

DROP TABLE IF EXISTS `tb_kelas_peserta`;

CREATE TABLE `tb_kelas_peserta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `tglLulus` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=907 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (890, 1, 1816, 115, '185000', 2, 'Aktif', '0000-00-00', '2026-01-16 14:09:03');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (891, 1, 1805, 115, '150000', 10, 'Aktif', '0000-00-00', '2026-01-16 14:09:08');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (892, 1, 1811, 118, '250000', 21, 'Aktif', '0000-00-00', '2026-01-16 14:10:35');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (893, 1, 1807, 115, '150000', 17, 'Aktif', '0000-00-00', '2026-01-16 14:10:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (894, 1, 1815, 119, '200000', 1, 'Aktif', '0000-00-00', '2026-01-16 14:10:50');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (895, 1, 1814, 115, '150000', 8, 'Aktif', '0000-00-00', '2026-01-16 14:11:53');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (896, 1, 1817, 115, '150000', 1, 'Aktif', '0000-00-00', '2026-01-16 14:11:54');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (897, 1, 1816, 116, '100000', 6, 'Aktif', '0000-00-00', '2026-01-16 14:12:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (898, 1, 1815, 116, '150000', 5, 'Aktif', '0000-00-00', '2026-01-16 14:12:25');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (899, 1, 1809, 115, '150000', 15, 'Aktif', '0000-00-00', '2026-01-16 14:12:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (900, 1, 1807, 117, '100000', 2, 'Aktif', '0000-00-00', '2026-01-16 14:12:30');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (901, 1, 1811, 115, '150000', 6, 'Aktif', '0000-00-00', '2026-01-16 14:12:32');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (902, 1, 1812, 115, '150000', 7, 'Aktif', '0000-00-00', '2026-01-16 14:14:05');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (903, 1, 1808, 115, '150000', 17, 'Aktif', '0000-00-00', '2026-01-16 14:14:10');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (904, 1, 1813, 115, '140000', 5, 'Tidak Aktif', '0000-00-00', '2026-01-16 14:14:23');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (905, 1, 1810, 119, '140000', 17, 'Aktif', '0000-00-00', '2026-01-16 14:14:34');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (906, 1, 1806, 115, '150000', 10, 'Aktif', '0000-00-00', '2026-01-16 14:15:25');


#
# TABLE STRUCTURE FOR: tb_log
#

DROP TABLE IF EXISTS `tb_log`;

CREATE TABLE `tb_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `ipAddress` varchar(32) NOT NULL,
  `device` text NOT NULL,
  `status` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4766 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4748, 1, '2404:c0:b602:ff62:6fe1:1978:5495', 'Mozilla/5.0 (X11; CrOS x86_64 14541.0.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'Logout', '2026-01-15 22:18:39');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4749, 1, '2404:c0:b602:ff62:b84e:ca54:cdaf', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2026-01-16 13:13:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4750, 1, '140.213.118.198', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36', 'Login', '2026-01-16 13:28:54');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4751, 1, '125.161.71.150', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2026-01-16 13:29:00');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4752, 1, '182.253.248.27', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.0.0 Safari/537.36', 'Login', '2026-01-16 13:29:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4753, 1, '180.244.228.132', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/123.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-16 13:29:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4754, 1, '121.101.129.80', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', 'Login', '2026-01-16 13:29:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4755, 1, '182.8.97.77', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-16 13:29:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4756, 1, '2404:c0:b602:ff62:7474:2c2f:4560', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2026-01-16 13:29:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4757, 1, '157.15.82.189', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-16 13:29:33');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4758, 1, '182.3.100.10', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2026-01-16 13:29:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4759, 1, '182.8.182.196', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-16 13:29:36');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4760, 1, '180.254.117.67', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36', 'Login', '2026-01-16 13:30:17');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4761, 1, '114.79.1.79', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-16 13:30:59');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4762, 1, '2404:c0:b602:ff62:8492:c326:8e8a', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-16 13:47:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4763, 1, '2404:c0:4220::ef:587f', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36', 'Login', '2026-01-16 14:07:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4764, 1, '182.8.97.77', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Logout', '2026-01-16 15:39:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4765, 1, '182.8.97.77', 'Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Mobile Safari/537.36', 'Login', '2026-01-16 15:39:34');


#
# TABLE STRUCTURE FOR: tb_qris
#

DROP TABLE IF EXISTS `tb_qris`;

CREATE TABLE `tb_qris` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gambar` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_rekening
#

DROP TABLE IF EXISTS `tb_rekening`;

CREATE TABLE `tb_rekening` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namaBank` varchar(10) NOT NULL,
  `noRekening` varchar(20) NOT NULL,
  `pemilik` varchar(50) NOT NULL,
  `terdaftar` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_setting
#

DROP TABLE IF EXISTS `tb_setting`;

CREATE TABLE `tb_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_subdomain` varchar(100) DEFAULT NULL,
  `expired_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_setting` (`id`, `nama_subdomain`, `expired_at`) VALUES (1, 'demo', '2026-01-17');


#
# TABLE STRUCTURE FOR: tb_siswa
#

DROP TABLE IF EXISTS `tb_siswa`;

CREATE TABLE `tb_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `noInduk` varchar(16) NOT NULL,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(16) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `tglLahir` date NOT NULL,
  `tglMasuk` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1818 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1805, '001', 'Auliya', 'Perempuan', '6281282500715', '2025-05-02', '2026-01-16', '2026-01-16 14:04:43');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1806, '007', 'Hanifah', 'Perempuan', '6287801368404', '2020-01-10', '2023-07-01', '2026-01-16 14:04:43');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1807, '001', 'Sayuti Wibowo', 'Laki-Laki', '6281213080985', '2020-03-18', '2026-01-01', '2026-01-16 14:04:58');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1808, '006', 'Nurul Oktafiani', 'Perempuan', '628563087003', '2025-01-16', '2026-01-16', '2026-01-16 14:05:03');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1809, '001', 'ETU WINDI', 'Perempuan', '6282178460316', '2025-12-03', '2026-01-01', '2026-01-16 14:05:11');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1810, '017', 'Makhfudoturrokhmah', 'Perempuan', '6287808121900', '2020-12-17', '2025-12-17', '2026-01-16 14:05:12');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1811, '212', 'Yulin Febriani ', 'Perempuan', '6281282392573', '2018-01-16', '2026-01-01', '2026-01-16 14:05:17');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1812, '10', 'arif', 'Laki-Laki', '6289681176118', '2020-01-10', '2025-02-07', '2026-01-16 14:05:26');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1813, '001', 'ani', 'Perempuan', '6285813613061', '2023-04-12', '2023-12-23', '2026-01-16 14:05:48');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1814, '008', 'Fatimah', 'Perempuan', '6282250935024', '2026-05-08', '2026-02-16', '2026-01-16 14:06:24');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1815, '008', 'Rachma Putri Kasimbara', 'Perempuan', '6281944829270', '2009-01-16', '2026-01-01', '2026-01-16 14:06:29');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1816, '006', 'masdalia', 'Perempuan', '6282346430546', '2026-01-28', '2026-01-08', '2026-01-16 14:07:52');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (1817, '001', 'Auliya', 'Perempuan', '6281282500715', '2025-05-02', '2026-01-16', '2026-01-16 14:11:20');


#
# TABLE STRUCTURE FOR: tb_tagihan
#

DROP TABLE IF EXISTS `tb_tagihan`;

CREATE TABLE `tb_tagihan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `bulan` int(11) NOT NULL,
  `tahun` int(11) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan` (`id`, `idAdmin`, `bulan`, `tahun`, `terdaftar`) VALUES (110, 1, 1, 2026, '2026-01-16 14:34:08');


#
# TABLE STRUCTURE FOR: tb_tagihan_siswa
#

DROP TABLE IF EXISTS `tb_tagihan_siswa`;

CREATE TABLE `tb_tagihan_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idTagihan` int(11) NOT NULL,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `jam` time NOT NULL,
  `tglBayar` date NOT NULL,
  `approve` varchar(64) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5301 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5285, 110, 1, 1805, 115, '150000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5286, 110, 1, 1811, 118, '250000', 21, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5287, 110, 1, 1807, 115, '150000', 17, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5288, 110, 1, 1815, 119, '200000', 1, 'Sudah Bayar', '15:14:00', '2026-01-05', 'Approve', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5289, 110, 1, 1814, 115, '150000', 8, 'Sudah Bayar', '14:59:00', '2026-01-16', 'Approve', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5290, 110, 1, 1817, 115, '300000', 10, 'Sudah Bayar', '15:00:00', '2026-01-16', 'Approve', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5292, 110, 1, 1815, 116, '150000', 5, 'Sudah Bayar', '15:01:00', '2026-02-01', 'Approve', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5293, 110, 1, 1809, 115, '150000', 15, 'Sudah Bayar', '14:59:00', '2026-01-16', 'Approve', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5294, 110, 1, 1807, 117, '100000', 2, 'Sudah Bayar', '15:00:00', '2026-01-16', 'Approve', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5295, 110, 1, 1811, 115, '150000', 6, 'Sudah Bayar', '14:59:00', '2026-01-16', 'Approve', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5296, 110, 1, 1812, 115, '150000', 7, 'Sudah Bayar', '14:59:00', '2026-01-16', 'Approve', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5297, 110, 1, 1808, 115, '150000', 17, 'Sudah Bayar', '15:00:00', '2026-01-16', 'Approve', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5299, 110, 1, 1810, 119, '140000', 17, 'Sudah Bayar', '15:05:00', '2026-01-16', 'Approve', '2026-01-16 14:34:08');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (5300, 110, 1, 1806, 115, '150000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-16 14:34:08');


#
# TABLE STRUCTURE FOR: tb_user
#

DROP TABLE IF EXISTS `tb_user`;

CREATE TABLE `tb_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(32) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `foto` varchar(128) NOT NULL,
  `skin` varchar(8) NOT NULL,
  `level` varchar(16) NOT NULL,
  `login` varchar(8) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (1, 'Yaniek Rahayu Isnaningtyas, M.Pd.', 'Perempuan', '6285730153434', 'yaniek.rahayu.isnaningtyas@gmail.com', 'Jombang, Jawa Timur', 'Admin', '$2y$10$vUU3./cWReuyc8r92yrdiOZWF5VEQAkVAX5gz8gkIjYw64yXbQTY6', 'no-image.png', 'blue', 'Administrator', 'Ya', '2023-05-20 09:36:23');
INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (56, 'Budi', 'Laki-Laki', '081234567890', 'easyapp@gmail.com', 'Jombang, Jawa Timur', 'budi', '$2y$10$z7/R3HeNPSMLKED0M6fCD.4jR.pNWiNcs9RXkOTp00ZR4smWEiKva', 'no-image.png', 'blue', 'Pegawai', 'Ya', '2026-01-16 13:38:52');


